//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to try to derive a class from anything
// other than another class or struct type.
//
// Note that we do not check to see if a class could be derived
// from some builtin type (like double) here because that would
// possibly evoke a syntax error, and we only want to test for
// semantic errors here.
//
// Cases:
//	an enum type
//	an enum variable
//	an enum literal
//	a global variable
//	a local variable
//	a function type
//	a function
//	a function pointer type
//	a function pointer
//	a builtin type
//	a union type
//	a union variable
//	a class object
//	a struct object


typedef float FLOAT;

enum enum_type { red, green, blue } enum_var;

class derived_1 : private enum_type {	// ERROR
};

class derived_2 : private enum_var {	// ERROR
	int data_member;
};

class derived_2_1 : private red {	// ERROR
	int data_member;
};

int global_variable;

class derived_3 : private global_variable {	// ERROR
	int data_member;
};


int test ()
{
	int local_variable;
	class derived_4 : private local_variable {	// ERROR
		int data_member;
	};

	local_variable = 0;
	return 0;
}

typedef int (function_type) ();

class derived_5 : private function_type {	// ERROR
	int data_member;
};

class derived_6 : private test {		// ERROR
	int data_member;
};

typedef int (*function_pointer_type) ();

class derived_7 : private function_pointer_type {	// ERROR
	int data_member;
};

function_pointer_type fpv;

class derived_8 : private fpv {		// ERROR
	int data_member;
};

class derived_9 : private FLOAT {	// ERROR
	int data_member;
};

union union_type { int i; float j; } union_variable;

class derived_10 : private union_type {		// ERROR
	int data_member;
};

class derived_11 : private union_variable {	// ERROR
	int data_member;
};

class base {
	int data_member;
} class_variable;

class derived_12 : private base {		// OK
	int data_member;
};

class derived_13 : private class_variable {	// ERROR
	int data_member;
};

struct struct_type {
	int member;
} struct_variable;

class derived_14 : private struct_type {	// OK
	int data_member;
};

class derived_15 : private struct_variable {	// ERROR
	int data_member;
};
