//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if the name of an overloaded function is
// passed as an actual argument to another overloaded
// function, it is an error if the name of the passed
// function (i.e. the function-address designator) could
// be ambiguous (given the context in which it is used).

overload function;
overload function_of_function;

void function (char c);
void function (float f);

typedef void (*ptr_to_function_of_char)(char);
typedef void (*ptr_to_function_of_float)(float);

void function_of_function (ptr_to_function_of_float);
void function_of_function (ptr_to_function_of_char);


void test ()
{
	function_of_function (function);	// ERROR - ambiguous
}
