//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that the "this" pointer is zero when a method is
// called for an object pointed to by a null pointer.

// Normally, the "__builtin_new" operation which actually
// allocates objects in heap space is *not* called at the
// actual point of the "new" keyword.  Rather, a check is
// made within each constructor and if the "this" pointer
// value passed in is zero, then the actual allocation of
// memory (via __builtin_new) is done at that point (i.e.
// at the very beginning of the constructor).

// A special trick allows one to subvert this mechanism.
// Specifically, if a given constructor contains a statement
// like: "this = this", then no attempt will be made to
// implicitly call __builtin_new within that constructor.

struct base {
	int member;

	base ();
	void member_function ();
};

base *base_pointer_1 = 0;
base *base_pointer_2 = 0;

int errors = 0;

int main ()
{
	//base_pointer_2 = new base();
	base_pointer_1->member_function ();
	return errors;
}

base::base ()
{
	this = this;
	if ((int) this != 0)
		errors++;
}

void base::member_function ()
{
	if ((int) this != 0)
		errors++;
}
