/*
 test/demo of OL classes
*/

#include <stream.h>
#include "intintOLSet.h"

int my_compare(int a, int b)
{
  return a - b;
}

void printint(int x)
{
  cout << x << " ";
}



void printintOLSet(intintOLSet& l)
{
  l.apply(printint);
  cout << "\n";
}


void some_ints(intintOLSet& a, int lo, int hi)
{
  for (int i = hi; i >= lo; --i)
    a.add(i);
}

void some_rands(intintOLSet& a, int n)
{
  while (n-- > 0)
    a.add((int)rand() % 50);
}

main()
{
  intintOLSet::item_item_comparison_function = my_compare;
  intintOLSet::key_item_comparison_function = my_compare;

  cout << "using OLSet of ints\n";
  intintOLSet a; some_ints(a, 1, 20);
  intintOLSet b; some_ints(b, 11, 30);
  intintOLSet c; some_rands(c, 20);
  intintOLSet d; some_rands(d, 20);
  
  cout << "a        ="; printintOLSet(a);
  cout << "b        ="; printintOLSet(b);
  cout << "c        ="; printintOLSet(c);
  cout << "d        ="; printintOLSet(d);
  intintOLSet f = a;
  cout << "f = a    ="; printintOLSet(f);

  cout << "a.contains(5)= " << a.contains(5) << "\n";
  cout << "a.del(5) ="; a.del(5); printintOLSet(a);

  intintOLSet e;
  cout << "e        ="; printintOLSet(e);
  e |= a;
  cout << "e |= a   ="; printintOLSet(e);
  e &= b;
  cout << "e &= b   ="; printintOLSet(e);
  e -= c;
  cout << "e -= c   ="; printintOLSet(e);
  e ^= d;
  cout << "e ^= d   ="; printintOLSet(e);
  cout << "deleting elements of e from f, one-by-one...\n";
  for (intintOLSetTrav ep(e); ep; ep.advance())
    f.del(ep.get());
  cout << "f        ="; printintOLSet(f);
  e.destructive_union(a);
  cout << "after e.destructive_union(a):\n";
  cout << "e        ="; printintOLSet(e);
  cout << "a        ="; printintOLSet(a);

  cout << "b via traverser:\n";
  for (intintOLSetTrav bp(b); bp; bp.advance())
    cout << bp.get() << ", ";
  cout << "\n";

  cout << "\nEnd of test\n";
}
