/*
 test/demo for PairingHeaps
*/

#include <stream.h>
#include "intPairingHeap.h"

int my_compare(int a, int b)
{
  return a - b;
}

main()
{
  intPairingHeap::comparison_function = my_compare;
  int x;
  intPairingHeap h(100);
  cout << "enqueuing 20 elements onto heap h:\n";
  for (int i = 0; i < 20; ++i)
  {
    x = rand() % 100;
    cout << x << " ";
    h.enq(x);
  }
  cout << "\nh.length() = " << h.length() << "\n";
  cout << "h.front() = " << h.front() << "\n";
  cout << "dequeuing 10 elements:\n";
  for (i = 0; i < 10; ++i)
    cout << h.deq() << " ";
  cout << "\nh.length() = " << h.length() << "\n";
  cout << "h.front() = " << h.front() << "\n";
  cout << "enqueuing 10 more:\n";
  for (i = 0; i < 10; ++i)
  {
    x = rand() % 100;
    cout << x << " ";
    h.enq(x);
  }
  cout << "\nh.length() = " << h.length() << "\n";
  cout << "h.front() = " << h.front() << "\n";
  cout << "first five valid elements via traverser:\n";
  i = 0;
  for (intPairingHeapTrav p (h); p && ( i < 5); i++, p.advance()) 
    cout << p.get() << " ";
  cout << "\ndeleting sixth valid element via traverser\n";
  cout << "element was " << p.get();
  p.del();
  cout << "\nh.length() = " << h.length() << "\n";
  cout << "h.front() = " << h.front() << "\n";
  cout << "dequeuing all of h:\n";
  while (!h.empty())
  {
    h.deq(x);
    cout << x << " ";
  }
  cout << "\nh.length() = " << h.length() << "\n";
  cout << "end of test.\n";
}
