
// Copyright (C) 1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

#ifndef _CPP_EXCEPTION
#define _CPP_EXCEPTION 1

#ifdef __GNUG__
#include_next <exception>
#else

#include <bits/stl_config.h>

__STL_BEGIN_NAMESPACE

    // 18.6  Exception handling
    class exception;
    class bad_exception;
     
    typedef void (*unexpected_handler)();
    unexpected_handler set_unexpected(unexpected_handler) throw();
    void unexpected();
    typedef void (*terminate_handler)();
    terminate_handler set_terminate(terminate_handler) throw();
    void terminate();
    bool uncaught_exception();

    // 18.6.1  Class exception 
    class exception {
    public:
      exception() throw();
      exception(const exception&) throw();
      exception& operator=(const exception&) throw();
      virtual ~exception() throw();
      virtual const char* what() const throw();
    };

    // 18.6.2.1  Class bad_exception 
    class bad_exception : public exception {
    public:
      bad_exception() throw();
      bad_exception(const bad_exception&) throw();
      bad_exception& operator=(const bad_exception&) throw();
      virtual ~bad_exception() throw();
      virtual const char* what() const throw();
    };

__STL_END_NAMESPACE

#endif /* __GNUG__ */

#endif /* _CPP_EXCEPTION */

// Local Variables:
// mode:C++
// End:
