/* Return cosine of complex float value.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"

__complex__ float
ccosf (__complex__ float x)
{
  __complex__ float res;

  if (!FINITEF_P (__real__ x) || __imag__ x != __imag__ x)
    {
      if (__real__ x == 0.0 || __imag__ x == 0.0)
	{
	  __real__ res = NAN;
	  __imag__ res = 0.0;
	}
      else if (INFINITE_P (__imag__ x))
	{
	  __real__ res = HUGE_VALF;
	  __imag__ res = NAN;
	}
      else
	{
	  __real__ res = NAN;
	  __imag__ res = NAN;
	}
    }
  else
    {
      __complex__ float y;

      __real__ y = -__imag__ x;
      __imag__ y = __real__ x;

      res = ccoshf (y);
    }

  return res;
}
