/* Complex hyperbole tangent for double.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ double
ctanh (__complex__ double x)
{
  __complex__ double res;

  if (!FINITE_P (__real__ x) || !FINITE_P (__imag__ x))
    {
      if (__isinf (__real__ x))
	{
	  __real__ res = __copysign (1.0, __real__ x);
	  __imag__ res = __copysign (0.0, __imag__ x);
	}
      else if (__imag__ x == 0.0)
	{
	  res = x;
	}
      else
	{
	  __real__ res = NAN;
	  __imag__ res = NAN;
	}
    }
  else
    {
      double sin2ix = sin (2.0 * __imag__ x);
      double cos2ix = cos (2.0 * __imag__ x);
      double den;

      den = (cosh (2.0 * __real__ x) + cos2ix);

      __real__ res = sinh (2.0 * __real__ x) / den;
      __imag__ res = sin2ix / den;
    }

  return res;
}
