var NAVTREE =
[
  [ "libstdc++", "index.html", [
    [ "Todo List", "a01752.html", null ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", null, [
      [ "Namespace List", "namespaces.html", "namespaces" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", "functions_type" ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ],
        [ "Related Functions", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", null, [
      [ "File List", "files.html", "files" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", null ],
        [ "Functions", "globals_func.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
".html",
"a00014.html#a6999e7df9948d6d507a24274356f74cc",
"a00021.html#ac99321a98ffc407b9747352bec9551c2",
"a00037.html#af1589e676c42857d454582cfa5d7ef9f",
"a00049.html#a4066f4bae97e20316477e952b0b42003",
"a00064.html#a699e9e58d771136c3253dc407ff0cf4a",
"a00066.html#afe9c4a3ba4e49ec92014f295639ad2c4",
"a00071.html#ae77ef8a76529317abdc2e6a66336e3ec",
"a00087.html#a116f8a9757b9966e5f62a92e00874235",
"a00093.html#a8a8600c69bc97aab796b5967c1e74b28",
"a00131.html#ad23d51cd81a0c26c99b8e2d6840e6698",
"a00159.html#a6c8c7846694fcbd41d9cbfcd26bf9e0f",
"a00203.html#ad6899b755da36c5fac1030476586b692aa8c442c03f7545e485210b7061d8509e",
"a00220.html#af0a2dc25dbba85fcd249ab120194f33e",
"a00227.html#ad141c6bd59fdd914a2f2042391428543",
"a00273.html#aefef56a4421cf30c8d2d150227b490bd",
"a00286.html#aabfe952bad24b9061854bb48e38f8554",
"a00298.html#a2ae944066f88dc12614dc9f81692ed89",
"a00311.html#a50b84a5aeb7c133ec7074c764a3005a6",
"a00316.html#aa2a63df4bc8cf694cfba52b65842e954",
"a00341.html#aa35581b0cad3df479e476214c266679f",
"a00378.html#ad3ed14179779bef123090318a6e751dd",
"a00406.html#a5e0f20dff2e5e259fcdd7b87297b93d1",
"a00427.html#a1a787ab151a50843d56563d55380867a",
"a00447.html#a4fb6d662a8351a9c790be9fbe78be8b4",
"a00449.html#a505c3780386ccd5ca9679f7264db97f9",
"a00450.html#aa840a3b92f45210eb6d512ea5fe11da3",
"a00452.html#aab4011ac7751c858f121b887f124529d",
"a00453.html#abc032043b1ae87565707f1bb41584ca4",
"a00466.html#aba82f0b94c1ed15ccacea0e98aa6cff6",
"a00475.html#aa748ce25c53c595cbb332058bf1841d3",
"a00482.html#a1f75fb78e5fdd2fb5242751fe1ad2dd3",
"a00485.html#a1140337194aa6923027c02c673016945",
"a00488.html#a5aabbc5d256f3eaaf313274ebf200877",
"a00491.html#aa245644963340f3dee07d384eeeb01f3",
"a00513.html",
"a00528.html#afee22cb59f8dd85b8342368eff2ae113",
"a00549.html#acdced1f5136cf1cdba379c1eab536d7a",
"a00554.html#a489b3585fdde7d4811ee12901954422f",
"a00560.html#a2ae5be5adaf4fadce838dbfd531296e7",
"a00578.html#aae0f69fe498930627177ff1f06d0ef9f",
"a00615.html#ad7de77bd98b01802701e0b55fc1e9205",
"a00620.html#afa84fb774c005122ed812ccf566af84b",
"a00625.html#a7d5c7fd6e4e458d2a47d1267b3822bfc",
"a00630.html#a032cae7a08161a82b08b647f07b41011",
"a00642.html#a7643f003a532a377d00ebe8bd288985f",
"a00643.html#ad2c34648fc18191d9660f7f784d1919a",
"a00646.html#a36867b4686f15a66df5c472b2d3fa67e",
"a00648.html#ac00d04322df723ab0315f3675083af96",
"a00651.html#a82f04dbbaeb4c368add2d2d045f3f95b",
"a00664.html#ab7e2aaada8e59653fe7d95d42faffde2",
"a00679.html#a426725452f3ac010eb3c090e83a6e574",
"a00695.html#a1cdc269c1678986e62a18b9613d2fd01",
"a00701.html#a63d9bee86255591990fd65813fac0639",
"a00707.html#ab355a648dead703816dacc28b68b6403",
"a00727.html#a3e6371e588094bd3278608c0e732cac4",
"a00762.html#a2929dd45c12623740d853c7e8de398e8",
"a00798.html#a5edba6c499d334a54a667ff4b115cd90",
"a00854.html#a75654a594dd9fd94bcf6712f9c3b8d2c",
"a00874.html",
"a00889.html#a19ac2e03d6662374eec118165f1424d7",
"a00900.html#ab729916c2674f3ad0a239433f7e69837",
"a00908.html#a4495aa1fb1dcd1ec56430fa80faec0ef",
"a00915.html#af19a4d0612899fd3458fde66279f4b58",
"a00925.html#a0e9d282823cd7811717ad6bd890f8626",
"a00949.html#gac5dbc0d791c11f4db2a8f32921d16527",
"a00977.html#ab78d201ccd82cec8eacb22f20a5d3d2e",
"a00991.html#ae3ea922b90e32b9711ee05d0df7ff629",
"a01014.html#a21d659d8a7b18d41726d04ed6451d1ce",
"a01017.html#ab8d7bdf04f958f040cfd842c6e2d7b6b",
"a01023.html#a4011aaa356a78e619dc272389a9472c2",
"a01030_source.html",
"a01032.html#aa1b3f16a81b9560f7dd6f97bc839b8a8",
"a01042.html",
"a01066.html#ac2fe1ae5759ab8186d15ee29cd9ab311",
"a01075.html#a6f896642ffc9618494e4a63804e894b5",
"a01097.html#gaf99ccb0f76133120f544efabaae15f80",
"a01145.html#a3fad953182116311f5b0a3f19e2cd99f",
"a01186.html#a2b2e3f002a2c338479c2b31ac81f07df",
"a01186.html#ab82e3cafd87b9ec0a7c4f3c92ac50a82",
"a01220.html#a25da23422018c2f962ea7956177afe5ba53793ee58fc24168a0d6549c3cb2df8e",
"a01255.html#afa1a59f283c617892bef247bcf1b2755",
"a01281.html#a985afcd0c5ecea027df66e0265b015ed",
"a01321.html#a1e9f4b22e1765b870ed4efc3802a2343",
"a01362.html",
"a01393.html#a256d027e813218385edaf71812b463d7",
"a01431.html#a7aaa0d56330093bde189a23fef012cd4",
"a01452.html#ga30ec0007b5169ab3c6847033db603493",
"a01468.html#gaaee0b4d314905566d4d083f1f3cabfa4",
"a01489.html#ae370281957d24eaf63c2e5af922a5190",
"a01546.html#a02899bd1f77dda6d0032cf376440b1e0",
"a01550.html#a23316ce7b02f71397fae8f22af72fefe",
"a01568.html#a8e956c18b6fde16b113a2fd01468879b",
"a01608.html#gaa382786c9e1797fbe9efb9bda86450b5",
"a01632.html#ga7033fc566160b4d9d7c65fa008717979",
"a01634.html#a8194836b849486b252e2307f29bfd9a6",
"a01681.html#ga72c21e0f95b2b3cb6ea2785ee4108b01",
"a01702.html#ga33b1639f219a2e1b2b0d8e7c6263a457",
"a01702.html#gafcd42f466b41bb7059f6edd3af7be4c8",
"a01715.html#gab03e70e48f17f27c9e74d12c63bc315a",
"functions_func_0x7e.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  } 
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  var imgNode = document.createElement("img");
  imgNode.style.paddingLeft=(16*level).toString()+'px';
  imgNode.width  = 16;
  imgNode.height = 22;
  imgNode.border = 0;
  if (node.childrenData) {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    imgNode.src = node.relpath+"ftv2node.png";
    domNode.appendChild(imgNode);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  if (anchor.parent().attr('class')=='memItemLeft' ||
      anchor.parent().attr('class')=='fieldtype' ||
      anchor.parent().is(':header')) 
  {
    pos = anchor.parent().position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath($(location).attr('pathname'));
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = $(location).attr('hash');
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+
               window.location.hash.substring(1)+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parents().slice(2).prop('tagName')=='TR') {
    glowEffect(anchor.parents('div.memitem'),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath($(location).attr('pathname'))+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).show();
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1];
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
    //root=root.replace(/_source\./,'.'); // source link to doc link
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2($(location).attr('pathname'))+$(location).attr('hash'));
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  navTo(o,toroot,window.location.hash,relpath);

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath($(location).attr('pathname'))+':'+
                               $(location).attr('hash').substring(1);
         a=$('.item a[class$="'+clslink+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2($(location).attr('pathname'));
       navTo(o,link,$(location).attr('hash'),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,window.location.hash,relpath);
     }
  })

  $(window).load(showRoot);
}

