/* Complex square root of float value.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ float
csqrtf (__complex__ float x)
{
  __complex__ float res;

  if (!FINITEF_P (__real__ x) || !FINITEF_P (__imag__ x))
    {
      if (INFINITEF_P (__imag__ x))
	{
	  __real__ res = HUGE_VALF;
	  __imag__ res = __imag__ x;
	}
      else if (INFINITEF_P (__real__ x))
	{
	  if (__real__ x < 0.0)
	    {
	      __real__ res = __imag__ x != __imag__ x ? NAN : 0;
	      __imag__ res = __copysignf (HUGE_VALF, __imag__ x);
	    }
	  else
	    {
	      __real__ res = __real__ x;
	      __imag__ res = (__imag__ x != __imag__ x
			      ? NAN : __copysignf (0.0, __imag__ x));
	    }
	}
      else
	{
	  __real__ res = NAN;
	  __imag__ res = NAN;
	}
    }
  else
    {
      if (__imag__ x == 0.0)
	{
	  if (__real__ x < 0.0)
	    {
	      __real__ res = 0.0;
	      __imag__ res = __copysignf (sqrtf (-__real__ x), __imag__ x);
	    }
	  else
	    {
	      __real__ res = fabsf (sqrtf (__real__ x));
	      __imag__ res = __copysignf (0.0, __imag__ x);
	    }
	}
      else if (__real__ x == 0.0)
	{
	  float r = sqrtf (0.5 * fabsf (__imag__ x));

	  __real__ res = __copysignf (r, __imag__ x);
	  __imag__ res = r;
	}
      else
	{
	  __complex__ float q;
	  float t, r;

	  if (fabsf (__imag__ x) < 2.0e-4 * fabsf (__real__ x))
	    t = 0.25 * __imag__ x * (__imag__ x / __real__ x);
	  else
	    t = 0.5 * (hypotf (__real__ x, __imag__ x) - __real__ x);

	  r = sqrtf (t);

	  __real__ q = __imag__ x / (2.0 * r);
	  __imag__ q = r;

	  /* Heron iteration in complex arithmetic.  */
	  res = 0.5 * (q + q / x);
	}
    }

  return res;
}
