/*
  Copyright (C) 2004 Paul Mackerras <paulus@samba.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307, USA.

  The GNU General Public License is contained in the file COPYING.
*/
#include "vg_unistd.h"
#include "vg_constants.h"

	.globl	VG_(do_syscall)
VG_(do_syscall):
	mr	0,3
	mr	3,4
	mr	4,5
	mr	5,6
	mr	6,7
	mr	7,8
	mr	8,9
	sc
	bnslr
	neg	3,3
	blr

/* int VG_(clone)(fn, child_stack, flags, arg, child_tid, parent_tid)	*/
/*		  r3, r4,	   r5,    r6,  r7,	  r8		*/

	.globl	VG_(clone)
VG_(clone):
	stwu	1,-32(1)
	stw	29,20(1)
	stw	30,24(1)
	stw	31,28(1)
	mr	30,3		/* function */
	mr	31,6		/* argument */
	mr	3,5		/* flags */
	rlwinm	4,4,0,~0xf	/* trim sp to multiple of 16 bytes */
	li	0,0
	stwu	0,-16(4)	/* make initial stack frame */
	mr	29,4
	mr	5,8		/* parent_tid */
	mr	6,2		/* child_threadptr */
	li	0,__NR_clone	/* child_tid already in r7 */
	sc
	bso	1f		/* if error */
	cmpwi	3,0
	beq	2f		/* if child */
9:	lwz	29,20(1)	/* parent - return */
	lwz	30,24(1)
	lwz	31,28(1)
	addi	1,1,32
	blr

	/* here we are the child */
	/* Note: 2.4 doesn't set the child stack pointer, so we do it here.
	   That does leave a small window for a signal to be delivered
	   on the wrong stack, unfortunately. */
2:	mr	1,29
	mtctr	30		/* function */
	mr	3,31		/* argument */
	bctrl			/* call it */
	li	0,__NR_exit	/* exit with result */
	sc
	.long	0		/* exit returned?? */

1:	neg	3,3		/* return -errno on error */
	b	9b
