
/*--------------------------------------------------------------------*/
/*--- Low-level syscall code for PowerPC.         vg_ppc_syscall.c ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Valgrind, an extensible
   emulator for monitoring program execution on Unixes.

   Copyright (C) 2000-2004 Julian Seward 
      jseward@acm.org
   Copyright (C) 2004 Paul Mackerras
      paulus@samba.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/


#include "vg_include.h"
#include "vg_proxylwp.h"

extern void do_thread_syscall(Int arg1, Int syscallno, Int *gprs, Int *cr,
			      enum PXState *statep, enum PXState poststate);

asm(
".text\n"
"	.type do_thread_syscall,@function\n"

"do_thread_syscall:\n"
"	stwu	1,-32(1)\n"
"	mflr	0\n"
"	stw	0,36(1)\n"
"	stw	31,28(1)\n"
"	mr	31,5\n"		/* gprs */
"	stw	30,24(1)\n"
"	mr	30,6\n"		/* cr */
"	stw	29,20(1)\n"
"	mr	29,7\n"		/* statep */
"	stw	28,16(1)\n"
"	mr	28,8\n"		/* poststate */
".sys_before:\n"
"	mr	0,4\n"		/* syscall */
/* arg1 is in r3 already */
"	lwz	4,16(31)\n"	/* arg2 */
"	lwz	5,20(31)\n"	/* arg3 */
"	lwz	6,24(31)\n"	/* arg4 */
"	lwz	7,28(31)\n"	/* arg5 */
"	lwz	8,32(31)\n"	/* arg6 */
".sys_restarted:\n"
"	sc\n"
".sys_after:\n"
"	stw	3,12(31)\n"	/* save result */
"	lwz	3,0(30)\n"	/* update cr */
"	mfcr	4\n"
"	rlwimi	3,4,0,3,3\n"	/* transfer cr0.so */
"	stw	3,0(30)\n"
"	cmpwi	29,0\n"
"	beq	.sys_done\n"
"	stw	28,0(29)\n"
".sys_done:\n"
"	lwz	28,16(1)\n"
"	lwz	29,20(1)\n"
"	lwz	30,24(1)\n"
"	lwz	31,28(1)\n"
"	addi	1,1,32\n"
"	blr\n"
"	.size do_thread_syscall,.-do_thread_syscall\n"
".previous\n"

".section .rodata\n"
"	.globl	sys_before\n"
"sys_before:	.long	.sys_before\n"
"	.globl	sys_restarted\n"
"sys_restarted:	.long	.sys_restarted\n"
"	.globl	sys_after\n"
"sys_after:	.long	.sys_after\n"
"	.globl	sys_done\n"
"sys_done:	.long	.sys_done\n"
".previous\n"
);

/* Run a syscall for a particular thread */
void VG_(thread_syscall)(Int syscallno, arch_thread_t *tst, 
			 enum PXState *state , enum PXState poststate)
{
   do_thread_syscall(tst->m_orig_gpr3, syscallno,
		     tst->m_gpr, &tst->m_cr,
		     state,	  /* state to update */
		     poststate);  /* state when syscall has finished */
   tst->m_result = (tst->m_cr & 0x10000000)? - tst->m_gpr[3]: tst->m_gpr[3];
}

void VG_(do_syscall_direct)(Int syscallno, arch_thread_t *tst)
{
   do_thread_syscall(tst->m_orig_gpr3, syscallno,
		     tst->m_gpr, &tst->m_cr, NULL, 0);
   tst->m_result = (tst->m_cr & 0x10000000)? - tst->m_gpr[3]: tst->m_gpr[3];
}

/* Back up to restart a system call. */
void VG_(arch_restart_syscall)(arch_thread_t *tst)
{
   tst->m_eip -= 4;		/* sizeof(sc) */
   {
      UInt *p = (UInt *)tst->m_eip;
      
      if (p[0] != 0x44000002)
	 VG_(message)(Vg_DebugMsg, 
		      "?! restarting over syscall at %p %08x\n",
		      tst->m_eip, p[0]);

      vg_assert(p[0] == 0x44000002);
   }
}
