
/*--------------------------------------------------------------------*/
/*--- Architecture-specific system call details  vg_arch_syscall.h ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Valgrind, an extensible x86 protected-mode
   emulator for monitoring program execution on x86-Unixes.

   Copyright (C) 2000-2004 Julian Seward 
      jseward@acm.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

#define ARCH_DO_MMAP(ret, start, length, prot, flags, fd, offset) {	\
   UInt __args[6];							\
									\
   __args[0] = (UInt)(start);						\
   __args[1] = (length);						\
   __args[2] = (prot);							\
   __args[3] = (flags);							\
   __args[4] = (fd);							\
   __args[5] = (offset);						\
									\
   ret = VG_(do_syscall)(__NR_mmap, (UInt)(&(__args[0])) ); 		\
}

#define ARCH_GET_MMAP_ARGS(tst, a1, a2, a3, a4, a5, a6) do {	\
   UInt *arg_block = (UInt *) ARCH_SYSCALL_ARG1(tst->arch);	\
   a1 = arg_block[0];						\
   a2 = arg_block[1];						\
   a3 = arg_block[2];						\
   a4 = arg_block[3];						\
   a5 = arg_block[4];						\
   a6 = arg_block[5];						\
} while (0)

/* XXX need a better place for these */
#define SIGCONTEXT_EIP(sc)	((sc).eip)
#define SIGCONTEXT_SYSNR(sc)	((sc).eax)

/* How to get from a ucontext to the register values it contains */
#define UCONTEXT_REGS(uc)	(&(uc).uc_mcontext)

#define ARCH_DO_SYSCALL_DIRECT(sysnr, regs) {		\
   (regs)->m_eax = VG_(do_syscall)(sysnr,		\
				   (regs)->m_ebx,	\
				   (regs)->m_ecx, 	\
				   (regs)->m_edx,	\
				   (regs)->m_esi,	\
				   (regs)->m_edi,	\
				   (regs)->m_ebp);	\
} while (0)
