/*
  Copyright (C) 2004 Paul Mackerras <paulus@samba.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307, USA.

  The GNU General Public License is contained in the file COPYING.
*/
#include "core_asm.h"

	.globl	VG_(run_innerloop)
VG_(run_innerloop):
	mflr	0
	stw	0,4(1)
	stwu	1,-80(1)
	stw	31,76(1)
	stw	30,72(1)
	stw	29,68(1)
	stw	28,64(1)
	stw	27,60(1)
	stw	26,56(1)
	stw	25,52(1)
	stw	24,48(1)
	stw	23,44(1)
	stw	22,40(1)
	stw	21,36(1)
	stw	20,32(1)
	stw	19,28(1)
	stw	18,24(1)
	stw	17,20(1)
	mr	31,3		/* points to our ThreadState */
	lwz	17,VGOFF_DISPATCH_CTR(31)
	lwz	18,VGOFF_cr(31)
	lwz	19,VGOFF_xer(31)
	lwz	30,VGOFF_eip(31)
	/* make a stack frame for the code we are calling */
	stwu	1,-16(1)
	stw	1,VGOFF_dispatch_sp(31)
	cmpw	1,0,0		/* set cr1 to "equals" */

dispatch_loop:
	li	3,VG_TRC_INNER_FASTMISS
	rlwinm	4,30,0,VG_TT_FAST_MASK<<2
	addis	4,4,VG_(tt_fast)@ha
	lwz	4,VG_(tt_fast)@l(4)
	cmpwi	4,0
	beq	innerloop_exit
	lwz	0,0(4)
	cmpw	0,30
	bne	innerloop_exit
	addi	4,4,VG_CODE_OFFSET
	mtctr	4
	beq	1,chain_cont
	/* try to chain the last BB to this one */
	subf	6,5,4		/* offset from branch to target */
	srawi	7,6,16		/* check it is in range */
	addi	7,7,0x0200
	cmplwi	7,0x400
	bge	chain_cont	/* can't chain, too far */
	lis	0,0x4800	/* make up a branch instruction */
	rlwimi	0,6,0,6,29	/* insert the offset */
	stw	0,0(5)		/* write the instruction in */
	addi	8,5,4
	lwz	7,-4(4)		/* get the old back chain */
	stw	7,0(8)		/* write it into the link word */
	stw	8,-4(4)		/* make the back chain point to us */
	dcbst	0,5		/* do the cache flush */
	sync
	icbi	0,5
	sync
	isync
	lis	9,VG_(bb_enchain_count)@ha
	lwz	8,VG_(bb_enchain_count)@l(9)
	addi	8,8,1
	stw	8,VG_(bb_enchain_count)@l(9)
chain_cont:
	lis	9,VG_(unchained_jumps_done)@ha
	lwz	8,VG_(unchained_jumps_done)@l(9)
	addi	8,8,1
	stw	8,VG_(unchained_jumps_done)@l(9)
	bctrl
	cmpwi	1,3,0
	cmpwi	0,17,0
	bgt	1,innerloop_exit
	li	3,VG_TRC_INNER_COUNTERZERO
	mflr	5
	addi	5,5,-4
	bne	dispatch_loop

innerloop_exit:
	addi	1,1,16
	stw	17,VGOFF_DISPATCH_CTR(31)
	stw	18,VGOFF_cr(31)
	stw	19,VGOFF_xer(31)
	stw	30,VGOFF_eip(31)
	li	0,0
	stw	0,VGOFF_dispatch_sp(31)
	lwz	17,20(1)
	lwz	18,24(1)
	lwz	19,28(1)
	lwz	20,32(1)
	lwz	21,36(1)
	lwz	22,40(1)
	lwz	23,44(1)
	lwz	24,48(1)
	lwz	25,52(1)
	lwz	26,56(1)
	lwz	27,60(1)
	lwz	28,64(1)
	lwz	29,68(1)
	lwz	30,72(1)
	lwz	31,76(1)
	lwz	0,84(1)
	mtlr	0
	addi	1,1,80
	blr
