/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright 2017 Mellanox Technologies, Ltd
 */

#include <tap_bpf.h>

/* bpf_insn array matching cls_q section. See tap_bpf_program.c file */
static struct bpf_insn cls_q_insns[] = {
	{0x61,    2,    1,       52, 0x00000000},
	{0x18,    3,    0,        0, 0xdeadbeef},
	{0x00,    0,    0,        0, 0x00000000},
	{0x63,   10,    3,       -4, 0x00000000},
	{0xb7,    0,    0,        0, 0x00000000},
	{0x61,    3,   10,       -4, 0x00000000},
	{0x07,    3,    0,        0, 0x7cafe800},
	{0x67,    3,    0,        0, 0x00000020},
	{0x77,    3,    0,        0, 0x00000020},
	{0x5d,    2,    3,        4, 0x00000000},
	{0xb7,    2,    0,        0, 0x00000000},
	{0x63,    1,    2,       52, 0x00000000},
	{0x18,    0,    0,        0, 0xffffffff},
	{0x00,    0,    0,        0, 0x00000000},
	{0x95,    0,    0,        0, 0x00000000},
};

/* bpf_insn array matching l3_l4 section. see tap_bpf_program.c file */
static struct bpf_insn l3_l4_hash_insns[] = {
	{0xbf,    7,    1,        0, 0x00000000},
	{0x61,    8,    7,       16, 0x00000000},
	{0x61,    6,    7,       76, 0x00000000},
	{0x61,    9,    7,       80, 0x00000000},
	{0x18,    1,    0,        0, 0xdeadbeef},
	{0x00,    0,    0,        0, 0x00000000},
	{0x63,   10,    1,       -4, 0x00000000},
	{0xbf,    2,   10,        0, 0x00000000},
	{0x07,    2,    0,        0, 0xfffffffc},
	{0x18,    1,    1,        0, 0x0000cafe},
	{0x00,    0,    0,        0, 0x00000000},
	{0x85,    0,    0,        0, 0x00000001},
	{0x55,    0,    0,       21, 0x00000000},
	{0xb7,    1,    0,        0, 0x00000a64},
	{0x6b,   10,    1,      -16, 0x00000000},
	{0x18,    1,    0,        0, 0x69666e6f},
	{0x00,    0,    0,        0, 0x65727567},
	{0x7b,   10,    1,      -24, 0x00000000},
	{0x18,    1,    0,        0, 0x6e207369},
	{0x00,    0,    0,        0, 0x6320746f},
	{0x7b,   10,    1,      -32, 0x00000000},
	{0x18,    1,    0,        0, 0x20737372},
	{0x00,    0,    0,        0, 0x2079656b},
	{0x7b,   10,    1,      -40, 0x00000000},
	{0x18,    1,    0,        0, 0x68736168},
	{0x00,    0,    0,        0, 0x203a2928},
	{0x7b,   10,    1,      -48, 0x00000000},
	{0xb7,    7,    0,        0, 0x00000000},
	{0x73,   10,    7,      -14, 0x00000000},
	{0xbf,    1,   10,        0, 0x00000000},
	{0x07,    1,    0,        0, 0xffffffd0},
	{0xb7,    2,    0,        0, 0x00000023},
	{0x85,    0,    0,        0, 0x00000006},
	{0x05,    0,    0,     1632, 0x00000000},
	{0xb7,    1,    0,        0, 0x0000000e},
	{0x61,    2,    7,       20, 0x00000000},
	{0x15,    2,    0,       10, 0x00000000},
	{0x61,    2,    7,       28, 0x00000000},
	{0x55,    2,    0,        8, 0x0000a888},
	{0xbf,    2,    7,        0, 0x00000000},
	{0xb7,    7,    0,        0, 0x00000000},
	{0xbf,    1,    6,        0, 0x00000000},
	{0x07,    1,    0,        0, 0x00000012},
	{0x2d,    1,    9,     1622, 0x00000000},
	{0xb7,    1,    0,        0, 0x00000012},
	{0x69,    8,    6,       16, 0x00000000},
	{0xbf,    7,    2,        0, 0x00000000},
	{0x7b,   10,    7,      -56, 0x00000000},
	{0x57,    8,    0,        0, 0x0000ffff},
	{0x15,    8,    0,      409, 0x0000dd86},
	{0xb7,    7,    0,        0, 0x00000003},
	{0x55,    8,    0,     1614, 0x00000008},
	{0x0f,    6,    1,        0, 0x00000000},
	{0xb7,    7,    0,        0, 0x00000000},
	{0xbf,    1,    6,        0, 0x00000000},
	{0x07,    1,    0,        0, 0x00000018},
	{0x2d,    1,    9,     1609, 0x00000000},
	{0x71,    3,    6,       12, 0x00000000},
	{0xbf,    1,    3,        0, 0x00000000},
	{0x67,    1,    0,        0, 0x00000038},
	{0xc7,    1,    0,        0, 0x00000020},
	{0x77,    1,    0,        0, 0x0000001f},
	{0x57,    1,    0,        0, 0x2cc681d1},
	{0x67,    3,    0,        0, 0x00000018},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x40000000},
	{0xb7,    2,    0,        0, 0x00000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x598d03a2},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x20000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb31a0745},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x10000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x66340e8a},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x08000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xcc681d15},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x04000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x98d03a2b},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x02000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x31a07456},
	{0x57,    3,    0,        0, 0x01000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6340e8ad},
	{0x71,    3,    6,       13, 0x00000000},
	{0x67,    3,    0,        0, 0x00000010},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00800000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc681d15b},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00400000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8d03a2b7},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00200000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1a07456f},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00100000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x340e8ade},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00080000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x681d15bd},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00040000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd03a2b7b},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00020000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa07456f6},
	{0x57,    3,    0,        0, 0x00010000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x40e8aded},
	{0x71,    3,    6,       14, 0x00000000},
	{0x67,    3,    0,        0, 0x00000008},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00008000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x81d15bdb},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00004000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x03a2b7b7},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00002000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x07456f6f},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00001000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x0e8adedf},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000800},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1d15bdbf},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000400},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3a2b7b7e},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000200},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7456f6fd},
	{0x57,    3,    0,        0, 0x00000100},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe8adedfa},
	{0x71,    3,    6,       15, 0x00000000},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000080},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd15bdbf4},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000040},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa2b7b7e9},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000020},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x456f6fd3},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000010},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8adedfa7},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000008},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x15bdbf4f},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000004},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x2b7b7e9e},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000002},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x56f6fd3d},
	{0x57,    3,    0,        0, 0x00000001},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xadedfa7b},
	{0x71,    4,    6,       16, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000038},
	{0xc7,    5,    0,        0, 0x00000020},
	{0xb7,    3,    0,        0, 0xffffffff},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x5bdbf4f7},
	{0x67,    4,    0,        0, 0x00000018},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb7b7e9ef},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6f6fd3df},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdedfa7bf},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xbdbf4f7f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7b7e9eff},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf6fd3dff},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xedfa7bfe},
	{0x71,    4,    6,       17, 0x00000000},
	{0x67,    4,    0,        0, 0x00000010},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00800000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdbf4f7fc},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00400000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb7e9eff9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00200000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6fd3dff2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00100000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdfa7bfe5},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00080000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xbf4f7fca},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00040000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7e9eff94},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00020000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfd3dff28},
	{0x57,    4,    0,        0, 0x00010000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfa7bfe51},
	{0x71,    4,    6,       18, 0x00000000},
	{0x67,    4,    0,        0, 0x00000008},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00008000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf4f7fca2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00004000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe9eff945},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00002000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd3dff28a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00001000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa7bfe514},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000800},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x4f7fca28},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000400},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9eff9450},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000200},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3dff28a0},
	{0x57,    4,    0,        0, 0x00000100},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7bfe5141},
	{0x71,    4,    6,       19, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000080},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf7fca283},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000040},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xeff94506},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000020},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdff28a0c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000010},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xbfe51418},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000008},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7fca2831},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000004},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xff945063},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000002},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xff28a0c6},
	{0x57,    4,    0,        0, 0x00000001},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfe51418c},
	{0x71,    4,    6,       20, 0x00000000},
	{0x67,    4,    0,        0, 0x00000008},
	{0x71,    5,    6,       21, 0x00000000},
	{0x4f,    4,    5,        0, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000030},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfca28319},
	{0x67,    4,    0,        0, 0x00000010},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x40000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf9450633},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x20000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf28a0c67},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x10000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe51418ce},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x08000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xca28319d},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x04000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9450633b},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x02000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x28a0c676},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x01000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x51418ced},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00800000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa28319db},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00400000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x450633b6},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00200000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8a0c676c},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00100000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1418ced8},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00080000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x28319db1},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00040000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x50633b63},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00020000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa0c676c6},
	{0x57,    4,    0,        0, 0x00010000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x418ced8d},
	{0x71,    3,    6,       22, 0x00000000},
	{0x67,    3,    0,        0, 0x00000008},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00008000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8319db1a},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00004000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x0633b634},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00002000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x0c676c68},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00001000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x18ced8d1},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000800},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x319db1a3},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000400},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x633b6347},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000200},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc676c68f},
	{0x57,    3,    0,        0, 0x00000100},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8ced8d1f},
	{0x71,    3,    6,       23, 0x00000000},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000080},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x19db1a3e},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000040},
	{0x79,    5,   10,      -56, 0x00000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x33b6347d},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000020},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x676c68fa},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000010},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xced8d1f4},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000008},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9db1a3e9},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000004},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3b6347d2},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000002},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x76c68fa5},
	{0x57,    3,    0,        0, 0x00000001},
	{0x1d,    3,    2,     1177, 0x00000000},
	{0xa7,    1,    0,        0, 0xed8d1f4a},
	{0x05,    0,    0,     1175, 0x00000000},
	{0x0f,    6,    1,        0, 0x00000000},
	{0xb7,    7,    0,        0, 0x00000000},
	{0xbf,    1,    6,        0, 0x00000000},
	{0x07,    1,    0,        0, 0x0000002c},
	{0x2d,    1,    9,     1202, 0x00000000},
	{0x61,    4,    6,        8, 0x00000000},
	{0xbf,    1,    4,        0, 0x00000000},
	{0x67,    1,    0,        0, 0x00000038},
	{0xc7,    1,    0,        0, 0x00000020},
	{0x77,    1,    0,        0, 0x0000001f},
	{0x57,    1,    0,        0, 0x2cc681d1},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000040},
	{0xb7,    2,    0,        0, 0x00000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x598d03a2},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000020},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb31a0745},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000010},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x66340e8a},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000008},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xcc681d15},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000004},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x98d03a2b},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000002},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x31a07456},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000001},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6340e8ad},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00008000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc681d15b},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00004000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8d03a2b7},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00002000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1a07456f},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00001000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x340e8ade},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000800},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x681d15bd},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000400},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd03a2b7b},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000200},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa07456f6},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00000100},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x40e8aded},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00800000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x81d15bdb},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00400000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x03a2b7b7},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00200000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x07456f6f},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00100000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x0e8adedf},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00080000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1d15bdbf},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00040000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3a2b7b7e},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00020000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7456f6fd},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00010000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe8adedfa},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000020},
	{0xc7,    5,    0,        0, 0x00000020},
	{0xb7,    3,    0,        0, 0xffffffff},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd15bdbf4},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa2b7b7e9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x456f6fd3},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8adedfa7},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x15bdbf4f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x2b7b7e9e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x56f6fd3d},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xadedfa7b},
	{0x61,    4,    6,       12, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000080},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x5bdbf4f7},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000040},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb7b7e9ef},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000020},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6f6fd3df},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000010},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdedfa7bf},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000008},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xbdbf4f7f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000004},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7b7e9eff},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000002},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf6fd3dff},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000001},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xedfa7bfe},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00008000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdbf4f7fc},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00004000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb7e9eff9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00002000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6fd3dff2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00001000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdfa7bfe5},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000800},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xbf4f7fca},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000400},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7e9eff94},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000200},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfd3dff28},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000100},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfa7bfe51},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00800000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf4f7fca2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00400000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe9eff945},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00200000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd3dff28a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00100000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa7bfe514},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00080000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x4f7fca28},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00040000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9eff9450},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00020000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3dff28a0},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00010000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7bfe5141},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000020},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf7fca283},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xeff94506},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdff28a0c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xbfe51418},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7fca2831},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xff945063},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xff28a0c6},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfe51418c},
	{0x61,    4,    6,       16, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000080},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfca28319},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000040},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf9450633},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000020},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf28a0c67},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000010},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe51418ce},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000008},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xca28319d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000004},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9450633b},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000002},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x28a0c676},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000001},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x51418ced},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00008000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa28319db},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00004000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x450633b6},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00002000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8a0c676c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00001000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1418ced8},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000800},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x28319db1},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000400},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x50633b63},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000200},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa0c676c6},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000100},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x418ced8d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00800000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8319db1a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00400000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x0633b634},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00200000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x0c676c68},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00100000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x18ced8d1},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00080000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x319db1a3},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00040000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x633b6347},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00020000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc676c68f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00010000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8ced8d1f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000020},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x19db1a3e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x33b6347d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x676c68fa},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xced8d1f4},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9db1a3e9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3b6347d2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x76c68fa5},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xed8d1f4a},
	{0x61,    4,    6,       20, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000080},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xdb1a3e94},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000040},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb6347d28},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000020},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6c68fa51},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000010},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd8d1f4a3},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000008},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb1a3e946},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000004},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6347d28d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000002},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc68fa51a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000001},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8d1f4a35},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00008000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1a3e946b},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00004000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x347d28d7},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00002000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x68fa51ae},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00001000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd1f4a35c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000800},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa3e946b9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000400},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x47d28d73},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000200},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8fa51ae7},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000100},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1f4a35cf},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00800000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3e946b9e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00400000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7d28d73c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00200000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfa51ae78},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00100000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf4a35cf1},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00080000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe946b9e3},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00040000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd28d73c7},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00020000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa51ae78e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00010000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x4a35cf1c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000020},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x946b9e38},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x28d73c71},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x51ae78e3},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa35cf1c6},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x46b9e38d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8d73c71b},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1ae78e36},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x35cf1c6c},
	{0x61,    4,    6,       24, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000080},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6b9e38d9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000040},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd73c71b2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000020},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xae78e364},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000010},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x5cf1c6c9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000008},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb9e38d92},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000004},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x73c71b25},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000002},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe78e364b},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000001},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xcf1c6c96},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00008000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9e38d92c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00004000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3c71b259},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00002000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x78e364b2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00001000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf1c6c964},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000800},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe38d92c9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000400},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc71b2593},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000200},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8e364b27},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000100},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1c6c964e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00800000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x38d92c9c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00400000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x71b25938},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00200000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe364b270},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00100000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc6c964e0},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00080000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8d92c9c0},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00040000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1b259380},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00020000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x364b2700},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00010000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6c964e01},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000020},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd92c9c03},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb2593807},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x64b2700f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc964e01e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x92c9c03d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x2593807a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x4b2700f4},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x964e01e8},
	{0x61,    4,    6,       28, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000080},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x2c9c03d1},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000040},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x593807a3},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000020},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb2700f46},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000010},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x64e01e8d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000008},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc9c03d1a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000004},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x93807a35},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000002},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x2700f46b},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000001},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x4e01e8d6},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00008000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9c03d1ad},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00004000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3807a35b},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00002000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x700f46b6},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00001000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe01e8d6c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000800},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc03d1ad9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000400},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x807a35b3},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000200},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x00f46b66},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000100},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x01e8d6cc},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00800000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x03d1ad99},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00400000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x07a35b32},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00200000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x0f46b665},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00100000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1e8d6cca},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00080000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3d1ad994},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00040000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7a35b328},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00020000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf46b6651},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00010000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe8d6cca2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000020},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd1ad9944},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa35b3289},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x46b66512},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8d6cca25},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1ad9944a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x35b32894},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6b665129},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd6cca253},
	{0x61,    4,    6,       32, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000080},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xad9944a7},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000040},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x5b32894f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000020},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb665129f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000010},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6cca253e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000008},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd9944a7d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000004},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb32894fb},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000002},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x665129f6},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000001},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xcca253ec},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00008000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9944a7d9},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00004000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x32894fb2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00002000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x65129f65},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00001000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xca253eca},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000800},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x944a7d95},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000400},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x2894fb2a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000200},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x5129f655},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000100},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa253ecab},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00800000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x44a7d956},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00400000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x894fb2ac},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00200000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x129f6558},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00100000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x253ecab1},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00080000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x4a7d9563},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00040000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x94fb2ac7},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00020000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x29f6558f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00010000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x53ecab1e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000020},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xa7d9563d},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x4fb2ac7a},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9f6558f5},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3ecab1ea},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7d9563d5},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfb2ac7ab},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf6558f56},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xecab1eac},
	{0x61,    4,    6,       36, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000080},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd9563d59},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000040},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb2ac7ab2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000020},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6558f564},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000010},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xcab1eac8},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000008},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9563d590},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000004},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x2ac7ab20},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000002},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x558f5641},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000001},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xab1eac83},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00008000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x563d5906},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00004000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xac7ab20c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00002000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x58f56418},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00001000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb1eac831},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000800},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x63d59063},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000400},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc7ab20c7},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000200},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8f56418f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00000100},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1eac831e},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00800000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3d59063c},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00400000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7ab20c78},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00200000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf56418f0},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00100000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xeac831e1},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00080000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xd59063c2},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00040000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xab20c784},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00020000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x56418f09},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x00010000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xac831e12},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000020},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x59063c25},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x40000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xb20c784b},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x20000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x6418f097},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x10000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc831e12f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x08000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9063c25f},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x04000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x20c784be},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x57,    5,    0,        0, 0x02000000},
	{0x1d,    5,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x418f097c},
	{0x57,    4,    0,        0, 0x01000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x831e12f9},
	{0x71,    4,    6,       40, 0x00000000},
	{0x67,    4,    0,        0, 0x00000008},
	{0x71,    5,    6,       41, 0x00000000},
	{0x4f,    4,    5,        0, 0x00000000},
	{0xbf,    5,    4,        0, 0x00000000},
	{0x67,    5,    0,        0, 0x00000030},
	{0xc7,    5,    0,        0, 0x00000020},
	{0x6d,    5,    3,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x063c25f3},
	{0x67,    4,    0,        0, 0x00000010},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x40000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x0c784be7},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x20000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x18f097cf},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x10000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x31e12f9f},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x08000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x63c25f3f},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x04000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc784be7f},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x02000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x8f097cff},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x01000000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x1e12f9fe},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00800000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3c25f3fc},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00400000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x784be7f8},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00200000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf097cff0},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00100000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe12f9fe0},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00080000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xc25f3fc1},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00040000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x84be7f83},
	{0xbf,    3,    4,        0, 0x00000000},
	{0x57,    3,    0,        0, 0x00020000},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x097cff07},
	{0x57,    4,    0,        0, 0x00010000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x12f9fe0f},
	{0x71,    3,    6,       42, 0x00000000},
	{0x67,    3,    0,        0, 0x00000008},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00008000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x25f3fc1f},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00004000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x4be7f83f},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00002000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x97cff07f},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00001000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x2f9fe0fe},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000800},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x5f3fc1fd},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000400},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xbe7f83fb},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000200},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7cff07f7},
	{0x57,    3,    0,        0, 0x00000100},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf9fe0fee},
	{0x71,    3,    6,       43, 0x00000000},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000080},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xf3fc1fdc},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000040},
	{0x79,    5,   10,      -56, 0x00000000},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xe7f83fb8},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000020},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xcff07f70},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000010},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x9fe0fee1},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000008},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x3fc1fdc2},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000004},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0x7f83fb85},
	{0xbf,    4,    3,        0, 0x00000000},
	{0x57,    4,    0,        0, 0x00000002},
	{0x1d,    4,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xff07f70a},
	{0x57,    3,    0,        0, 0x00000001},
	{0x1d,    3,    2,        1, 0x00000000},
	{0xa7,    1,    0,        0, 0xfe0fee15},
	{0x71,    2,    0,      201, 0x00000000},
	{0x67,    2,    0,        0, 0x00000008},
	{0x71,    3,    0,      200, 0x00000000},
	{0x4f,    2,    3,        0, 0x00000000},
	{0x71,    3,    0,      203, 0x00000000},
	{0x67,    3,    0,        0, 0x00000008},
	{0x71,    4,    0,      202, 0x00000000},
	{0x4f,    3,    4,        0, 0x00000000},
	{0x67,    3,    0,        0, 0x00000010},
	{0x4f,    3,    2,        0, 0x00000000},
	{0x67,    1,    0,        0, 0x00000020},
	{0x77,    1,    0,        0, 0x00000020},
	{0xbf,    2,    1,        0, 0x00000000},
	{0x3f,    2,    3,        0, 0x00000000},
	{0x2f,    2,    3,        0, 0x00000000},
	{0x1f,    1,    2,        0, 0x00000000},
	{0x57,    1,    0,        0, 0x0000000f},
	{0x67,    1,    0,        0, 0x00000002},
	{0x0f,    0,    1,        0, 0x00000000},
	{0x71,    1,    0,      137, 0x00000000},
	{0x67,    1,    0,        0, 0x00000008},
	{0x71,    2,    0,      136, 0x00000000},
	{0x4f,    1,    2,        0, 0x00000000},
	{0x71,    2,    0,      138, 0x00000000},
	{0x71,    3,    0,      139, 0x00000000},
	{0x67,    3,    0,        0, 0x00000008},
	{0x4f,    3,    2,        0, 0x00000000},
	{0x67,    3,    0,        0, 0x00000010},
	{0x4f,    3,    1,        0, 0x00000000},
	{0x07,    3,    0,        0, 0x7cafe800},
	{0x63,    5,    3,       52, 0x00000000},
	{0xb7,    7,    0,        0, 0x00000001},
	{0xbf,    0,    7,        0, 0x00000000},
	{0x95,    0,    0,        0, 0x00000000},
};
